ORCA/M Asm65816 2.1.0

0001 0115              *******************************************************************************
0002 0115              * InitCode.Pch
0003 0115              *
0004 0115              * (C)  Copyright Apple Computer, Inc. 1990
0005 0115              * All rights reserved.
0006 0115              *
0007 0115              * by Jim Mensch
0008 0115              * 5/11/90
0009 0115              *
0010 0115              * This file will contain all the 1 time code required for the ts3 patch. This way
0011 0115              * It can all be unloaded at the same time.
0012 0115              *
0013 0115              *
0014 0115              * Modification History:
0015 0115              *
0016 0115              * Version 1.0       Mensch
0017 0115              *
0018 0115              * 24-Sep-90         Dave Lyons
0019 0115              *
0020 0115              * Added patch entries for new calls:  Get640Colors and Set640Color.
0021 0115              *
0022 0115              * 22-Oct-90         Dave Lyons
0023 0115              *
0024 0115              * Added patch entry for new call GetScanlineAddr ($DC04).
0025 0115              *
0026 0115              * 25-Nov-90         Dave Lyons
0027 0115              *
0028 0115              * Added TablePatch entries for MyClearScreen and MyQDShutDown.
0029 0115              *
0030 0115              * 14-Feb-91         Dave Lyons
0031 0115              *
0032 0115              * Removed GetScanlineAddress.
0033 0115              *
0034 0115              * 18-Feb-91         Dave Lyons
0035 0115              *
0036 0115              * Re-enabled the MySetCursor patch (by Mensch for animated-cursor support).
0037 0115              *
0038 0115              * 11-Mar-91         Dave Lyons
0039 0115              *
0040 0115              * Removed MySetCursor again.  Not that hot, and it seems to cause cursor
0041 0115              * wars with Video Keyboard.
0042 0115              *
0043 0115              * 5-Aug-91          Dave Lyons
0044 0115              *
0045 0115              * Patched SetCursor *again*...this time, it looks at bit 31 of the new
0046 0115              * cursor pointer.
0047 0115              *
0048 0115              * 27-Nov-91         Dave Lyons
0049 0115              *
0050 0115              * Added tablePatch for InflateTextBuffer.
0051 0115              *
0052 0115              *******************************************************************************
0053 0115
0054 0115                       include 'all.macros' 
0055 0115
0056 0115                       include ':::qd:qdequates:qd.data.asm' 
0057 0115                       INCLUDE ':::qd:QDEquates:CORE.GLOBALS1' 
0058 0115                       INCLUDE ':::qd:QDEquates:core.globals2' 
0059 0115                       INCLUDE ':::qd:QDEquates:region.equs' 
0060 0115                       INCLUDE ':::qd:QDEquates:RECT.EQUS' 
0061 0115                       INCLUDE ':::qd:QDEquates:SLAB.EQUS' 
0062 0115                       INCLUDE ':::qd:QDEquates:rgndefs.equs' 
0063 0115                       include 'e16.memory' 
0064 0115                       Import iDrawCursor 
0065 0115                       Import iunDrawCursor 
0066 0115                       Import AnRTL 
0067 0115                       import iSetStuffAdr 
0068 0115                       import iBlowItUp 
0069 0115                       import DoADirtyDeed            ; from FontMgr.Pch
0070 0115              * re-enabled these 2 lines 17-Sep-90 DAL
0071 0115                       import DoADirtyDeed2           ; from MenuMgr.Pch
0072 0115                       import DoADirtyDeed3           ; from MenuMgr.Pch
0073 0115              *
0074 0115                       Import iSetUpScanPtrs 
0075 0115                       import MyClearScreen           ; from QD.pch
0076 0115                       import MyQDShutDown            ; from QD.pch
0077 0115                       import MyInflateTextBuffer     ; from QD.pch
0078 0115
0079 0115              *******************************************************************************
0080 0115
0081 0115
0082 0115              ****************************************************************
0083 0115              *
0084 0115              InstallQDPatch PROC Export 
0085 0115              *
0086 0115              * This routine installs the patches to QD's vectors and
0087 0115              * returns
0088 0115              *
0089 0115              *
0090 0115              * Inputs:
0091 0115              *                   none
0092 0115              *
0093 0115              * Outputs:
0094 0115              *                   all registers may be trashed.
0095 0115              *
0096 0115              * External Refs:
0097 0115                       import SetPort 
0098 0115              *
0099 0115              * Entry Points:
0100 0115              *                   none
0101 0115              *
0102 0115                       longa on                       ; mode
0103 0115                       longi on 
0104 0115              *
0105 0115              ****************************************************************
0106 0115              NumQDCalls equ   $DB                    ;22-Oct-90 DAL
0107 0115              CallTableSize equ   4*(NumQDCalls+1)
0108 0115              LocalTemp equ   0
0109 0115              SetPortOffset equ   $1B*4
0110 0115
0111 0115              *** re-enabled these 2 lines 17-Sep-90 DAL
0112 0115              SetForeColorOffset equ   $A0*4          ; offset into call table for SetForeColor
0113 0115              PtInRectOffset equ   $4F*4              ; offset into call table for PtInRect
0114 0115
0115 0115 8B                    phb   
0116 0116 F4 E0 E0              pea   $E0E0
0117 0119 AB                    plb   
0118 011A AB                    plb   
0119 011B
0120 011B A9 BF 75 8D           Patch GimmeVersion
0121 0127 A9 4C 76 8D           Patch SetSlabAdr
0122 0133 A9 05 76 8D           Patch SetSliceAdr
0123 013F A9 5B 77 8D           Patch RotateMask
0124 014B A9 E0 75 8D           Patch SeekRgn                  ; fix the scan up stuff in seek rgn
0125 0157 A9 C3 75 8D           Patch SetUpScanPtrs
0126 0163              ;	patch DrawCursor	; removed for 5.0.3
0127 0163              ;	patch unDrawCursor
0128 0163
0129 0163 AB                    plb   
0130 0164
0131 0164              ;
0132 0164              ; Get memory for the call table
0133 0164              ;
0134 0164 48                    pha   
0135 0165 48                    pha   
0136 0166 F4 00 00 F4           PushLong #CallTableSize 
0137 016C 48                    pha   
0138 016D A2 02 02 22           _MMStartup 
0139 0174 F4 08 40              PushWord #attrFixed+attrNoSpec 
0140 0177 48                    pha   
0141 0178 48                    pha   
0142 0179 A2 02 09 22           _NewHandle 
0143 0180
0144 0180              ;
0145 0180              ; Deref the handle put result in LocalTemp
0146 0180              ; 
0147 0180 68                    pla   
0148 0181 85 00                 sta   LocalTemp
0149 0183 68                    pla   
0150 0184 85 02                 sta   LocalTemp+2
0151 0186
0152 0186 A0 02 00              ldy   #2
0153 0189 B7 00                 lda   [LocalTemp],y
0154 018B AA                    tax   
0155 018C A7 00                 lda   [LocalTemp]
0156 018E 85 00                 sta   LocalTemp
0157 0190 86 02                 stx   LocalTemp+2
0158 0192
0159 0192              ;
0160 0192              ; Zero the call table
0161 0192              ;
0162 0192
0163 0192 A0 6E 03              ldy   #CallTableSize-2
0164 0195 A9 00 00              lda   #0
0165 0198 97 00        @Loop    sta   [LocalTemp],y
0166 019A 88                    dey   
0167 019B 88                    dey   
0168 019C 10 FA                 bpl   @Loop
0169 019E
0170 019E
0171 019E              ;
0172 019E              ; Put the number of calls into the call table
0173 019E              ;
0174 019E A9 DC 00              lda   #NumQDCalls+1
0175 01A1 87 00                 sta   [LocalTemp]
0176 01A3
0177 01A3              ;
0178 01A3              ; Point the boot init to an RTL
0179 01A3              ;
0180 01A3 A9 2E 74              lda   #AnRTL-1
0181 01A6 A0 04 00              ldy   #4
0182 01A9 97 00                 sta   [LocalTemp],y
0183 01AB C8                    iny   
0184 01AC C8                    iny   
0185 01AD A9 02 00              lda   #^AnRTL
0186 01B0 97 00                 sta   [LocalTemp],y
0187 01B2
0188 01B2              ;
0189 01B2              ; Point SetPort to the patch
0190 01B2              ;
0191 01B2 A0 6C 00              ldy   #SetPortOffset
0192 01B5 A9 0A 78              lda   #SetPort-1
0193 01B8 97 00                 sta   [LocalTemp],y
0194 01BA C8                    iny   
0195 01BB C8                    iny   
0196 01BC A9 02 00              lda   #^SetPort
0197 01BF 97 00                 sta   [LocalTemp],y
0198 01C1
0199 01C1              ;
0200 01C1              ; Point SetForeColor to the patch
0201 01C1              ; (re-enabled this patch 17-Sep-90 DAL)
0202 01C1 A0 80 02              ldy   #SetForeColorOffset      ;patch out _SetForeColor
0203 01C4 A9 31 78              lda   #SetForeColor-1
0204 01C7 97 00                 sta   [LocalTemp],y
0205 01C9 C8                    iny   
0206 01CA C8                    iny   
0207 01CB A9 02 00              lda   #^SetForeColor
0208 01CE 97 00                 sta   [LocalTemp],y
0209 01D0              ;
0210 01D0              ; Point PtInRect to the patch
0211 01D0              ; (re-enabled this patch 17-Sep-90 DAL)
0212 01D0 A0 3C 01              ldy   #PtInRectOffset          ;patch out _PtInRect
0213 01D3 A9 48 78              lda   #PtInRect-1
0214 01D6 97 00                 sta   [LocalTemp],y
0215 01D8 C8                    iny   
0216 01D9 C8                    iny   
0217 01DA A9 02 00              lda   #^PtInRect
0218 01DD 97 00                 sta   [LocalTemp],y
0219 01DF              ;
0220 01DF              ; And of course the rest of the patches...
0221 01DF
0222 01DF A0 C4 01 A9           tablePatch SectRgn,$71 
0223 01EE A0 C8 01 A9           tablePatch UnionRgn,$72 
0224 01FD A0 CC 01 A9           tablePatch DiffRgn,$73 
0225 020C A0 D0 01 A9           tablePatch XorRgn,$74 
0226 021B
0227 021B A0 38 02 A9           tablePatch MySetCursor,$8E     ;re-enabled 5-Aug-91 DAL
0228 022A A0 08 00 A9           tablePatch MyStartup,$02 
0229 0239
0230 0239 A0 68 03 A9           tablePatch Get640Colors,$DA    ;24-Sep-90 DAL
0231 0248 A0 6C 03 A9           tablePatch Set640Color,$DB     ;24-Sep-90 DAL
0232 0257 A0 54 00 A9           tablePatch MyClearScreen,$15   ;25-Nov-90 DAL
0233 0266 A0 0C 00 A9           tablePatch MyQDShutDown,$03    ;25-Nov-90 DAL
0234 0275 A0 5C 03 A9           tablePatch MyInflateTextBuffer,$D7  ;27-Nov-91 DAL
0235 0284              ;
0236 0284              ; Install the patch
0237 0284              ;
0238 0284 F4 00 00              PushWord #0 
0239 0287 F4 04 00              PushWord #4 
0240 028A D4 02                 pei   LocalTemp+2
0241 028C D4 00                 pei   LocalTemp
0242 028E A2 01 0A 22           _SetTSPtr 
0243 0295
0244 0295 6B                    RTL   
0245 0296
0246 0296                       EndP 
0247 0296
0248 0296                       End   
